/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.certs.ServerCert;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import java.util.Date;

public class ModifyCertExpBean
extends PanelBean
implements CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTMDED";
    private static final String TRACE_MASKF = "XCRTMDEF";
    private static final String TRACE_MASKT = "XCRTMDET";
    private ServerCert certificate;
    private String m_sNumOfDays;

    public ModifyCertExpBean(ServerCert certificate, String name) {
        this.certificate = certificate;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->ModifyCertExpBean(" + certificate + ", " + name + ")");
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public String getNumOfDays() {
        Trace.trace(TRACE_MASKT, "<->getNumOfDays() returning " + this.m_sNumOfDays);
        return this.m_sNumOfDays;
    }

    public void setNumOfDays(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "->setNumOfDays(" + s + ")");
        this.m_sNumOfDays = String.valueOf(CertMgtPanelUtils.parseNumOfDays(s));
    }

    public void load() {
        Integer days = null;
        int daysAsInt = 0;
        Date date = null;
        if (this.certificate != null) {
            days = this.certificate.getNumOfDays();
            if (days != null) {
                daysAsInt = days;
            } else {
                date = this.certificate.getNotAfter();
                if (date != null) {
                    try {
                        daysAsInt = CertUtils.wholeDaysGreater(date, new Date()) + 1;
                    }
                    catch (HException e) {
                        // empty catch block
                    }
                }
            }
        }
        this.m_sNumOfDays = daysAsInt > 0 ? String.valueOf(daysAsInt) : "100";
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        String elementName = null;
        String actionCommand = null;
        UserTaskManager utm = null;
        Trace.trace(TRACE_MASKT, "->panelAction(" + event + ")");
        if (event != null) {
            Trace.trace(TRACE_MASKF, "Bean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
            elementName = event.getElementName();
            actionCommand = event.getActionCommand();
            utm = this.getUserTaskManager();
            if (elementName.equals("ModifyServerCertExpOKButton")) {
                if (utm != null) {
                    utm.storeAllElements();
                }
                CertMgtPanelUtils.sendTaskletRequest("finishModExp", new Integer(this.getNumOfDays()), null, null, this);
            } else if (elementName.equals("CancelButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }
}

